{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:39:04 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  {$IFDEF WIN32}
  Windows,
  {$ELSE}
  WinTypes,
  WinProcs,
  {$ENDIF}
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  MMObj,
  MMWave,
  MMACMDlg,
  MMDesign,
  MMConect,
  MMWavIn,
  MMWInfo,
  MMFXGen,
  MMWavOut,
  MPlayer,
  MMCDInfo,
  MMSpectr,
  MMLevel,
  MMDIBCv,
  MMOscope,
  MMSpGram,
  MMMeter,
  MMHTimer,
  MMEnvelp,
  MMDSPObj, MMHook;

type
  TForm1 = class(TForm)
    MMACM1: TMMACM;
    MMWaveFile1: TMMWaveFile;
    MMWaveInfoEditor1: TMMWaveInfoEditor;
    MMGenerator1: TMMGenerator;
    MMGenerator2: TMMGenerator;
    MMGenerator3: TMMGenerator;
    MMGenerator4: TMMGenerator;
    MMWaveOut1: TMMWaveOut;
    MMConnector1: TMMConnector;
    MMCDInfo1: TMMCDInfo;
    MediaPlayer1: TMediaPlayer;
    MMMemoryWave1: TMMMemoryWave;
    MMOscope1: TMMOscope;
    MMOscope2: TMMOscope;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    MMSpectrum1: TMMSpectrum;
    MMSpectrum2: TMMSpectrum;
    MMMeter1: TMMMeter;
    MMMeter2: TMMMeter;
    MMSpectrogram1: TMMSpectrogram;
    MMWaveIn1: TMMWaveIn;
    MMSpectrogram2: TMMSpectrogram;
    ShowFPS: TCheckBox;
    Timer1: TTimer;
    MMSpectrum3: TMMSpectrum;
    MMSpectrum4: TMMSpectrum;
    MMDesigner1: TMMDesigner;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure MMHiTimer1Timer(Sender: TObject);
    procedure MMThread1Thread;
    procedure Timer1Timer(Sender: TObject);
  private
    oldRefreshCount: integer;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
   MMWaveIn1.Start;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
   MMWaveIn1.Close;
end;

procedure TForm1.MMHiTimer1Timer(Sender: TObject);
begin
   MMConnector1.Trigger;
end;

procedure TForm1.MMThread1Thread;
begin
   MMConnector1.Trigger;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
Var
   Temp: Longint;

begin
   if ShowFPS.Checked AND (MMConnector1.RefreshCountOscope <> OldRefreshCount) then
   begin
      Temp := MMConnector1.RefreshCountOscope;
      ShowFPS.Caption := ' ' + IntToStr(Temp) + ' frames/s';
      OldRefreshCount := Temp;
   end;
   MMConnector1.RefreshCountOscope := 0;
end;

end.
